#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include scripts\utility;


init(){
    precachemodel( "equip_iw4_throwingknife_npc" );
    replacefunc(maps\mp\gametypes\_weapons::throwingknifeusage, ::autoPickupThrowingKnife);
}



autoPickupThrowingKnife(){
	self endon("death");
	self endon("disconnect");
	for(;;){
		self waittill("grenade_fire", grenade, weaponName);
        if(isdefined(grenade) && weaponName == "iw9_throwknife_mp"){
            grenade thread waitForStick();
        }
	}
}

waitForStick(){
	self waittill("missile_stuck");
	oldOrigin = undefined;
	while(self.origin != oldOrigin){
        oldOrigin = self.origin;
        wait 1;
    }
	pos = self.origin;
	model = spawn( "script_model", pos );
	model setModel("equip_iw4_throwingknife_npc");
	model.angles = self.angles;
	trigger = spawn( "trigger_radius", pos-(0,0,45), 0, 30, 50 );
	trigger thread watchTimeout(model);
	self delete();
	while(isdefined(trigger))
	{
		trigger waittill( "trigger", player );
		if(Distance(pos, player getTagOrigin("j_head")) <= 75 && player hasWeapon("iw9_throwknife_mp") && player getammocount("iw9_throwknife_mp") == 0)
		{
			player setlethalweapon("iw9_throwknife_mp");
			player maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
			player setWeaponAmmoClip("iw9_throwknife_mp", 1);
			player playLocalSound("h2_scavenger_pack_pickup");
			trigger notify("deleted");
			model delete();
			trigger delete();
		}
		wait 0.025;
	}
}

watchTimeout(model){
	self endon("deleted");
	wait 60;
	model delete();
	self delete();
}